using MicroFour.StrataFrame.Tools;
using System.Web.Configuration;
using CommonBusiness;

public class ApplicationBasePage : MicroFour.StrataFrame.UI.Web.BasePage, MicroFour.StrataFrame.Tools.ITypeResolver
{

#region  Business Object Declarations 

	//-- Business Objects defined within this class will be available to 
	//   inherited pages as binding sources to bindable controls.  These 
	//   business objects will also be persisted within session variables 
	//   and retrieved each time the page loads.  If the business object 
	//   is declared WithEvents, events can be handled without the need 
	//   for AddHandler calls.
    private CustomersBO _Customers = new CustomersBO();

    public CustomersBO Customers
    {
        get { return _Customers; }
        set { _Customers = value; }
    }

#endregion

#region  ITypeResolver Implementation 

	/// <summary>
	/// Must be used by the StrataFrame Application Framework to resolve a type 
	/// within this ASP.NET project due to the fact that the Entry Assembly 
	/// cannot be evaluated in an ASP.NET application
	/// </summary>
	/// <param name="TypeName"></param>
	/// <returns></returns>
	/// <remarks></remarks>
	public System.Type ResolveType(string TypeName)
	{
		//-- Return the gettype for the given TypeName
		return System.Type.GetType(TypeName, false, true);
	}

	/// <summary>
	/// Returns the configuration section to the base class allowing the StrataFrame 
	/// Application Framework to access the assemblies referenced by this project.
	/// </summary>
	/// <returns></returns>
	/// <remarks></remarks>
	public CompilationSection GetCompilationSection()
	{
		return (CompilationSection)WebConfigurationManager.GetSection("system.web/compilation");
	}

#endregion

#region  Handled Events 

//ORIGINAL LINE: Private Sub Page_PreRender1(ByVal sender As Object, ByVal e As System.EventArgs) Handles this.PreRender
	override protected void OnPreRender(System.EventArgs e)
	{
		base.OnPreRender(e);
		this.ErrorIcon = "images/brokenrule.gif";
	}

#endregion

#region  Common Methods 

	/// <summary>
	/// Generates a warning table
	/// </summary>
	/// <param name="WarningText"></param>
	/// <returns></returns>
	/// <remarks></remarks>
	public string GenerateWarningTable(string WarningText)
	{
		//-- Establish Locals
		string lcReturn = "<table cellspacing='0' cellpadding='2' class='ErrorTable'><tr><td class='ErrorImageCell'><img src='images/warning_error.gif'</td><td class='ErrorTextCell'>";

		//-- Add the text to the warning table
		lcReturn += WarningText + "</td></tr></table>";

		//-- Return the table
		return lcReturn;
	}

#endregion

}